/** @file   MinigunBullet.h
 * @brief   Declaration of MinigunBullet class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MINIGUNBULLET_H
#define H_WWW_MINIGUNBULLET_H

#include "bullet.h"


namespace WeWantWar {

/** @class  MinigunBullet
 * @brief   Represents a minigun bullet.
 * @author  Tomi Lamminsaari
 *
 */
class MinigunBullet : public Bullet
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aShooter          Pointer to GameObject who shot this.
   * @param   aPos              Starting position.
   */
  MinigunBullet( GameObject* aShooter, const eng2d::Vec2D& aPos );

  /** Destructor
   */
  ~MinigunBullet();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another MinigunBullet
   */
  MinigunBullet( const MinigunBullet& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another MinigunBullet
   * @return  Reference to this object.
   */
  MinigunBullet& operator= ( const MinigunBullet& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Draws this bullet.
   * @param   aBitmap           Pointer to target bitmap.
   */
  virtual void redraw( BITMAP* aBitmap ) const;
  
};

};  // end of namespace

#endif
